
	output COLECOCONV.rom
	
	defpage	0,0x4000, 0x8000		; page 0 contains main code + far call routines
	defpage 1,0x4000, 0x8000
	defpage 2,0x4000, 0x8000
	defpage 3,0x4000, 0x8000
	defpage 4,0x4000, 0x8000
	defpage 5,0x4000, 0x8000
	defpage 6,0x4000, 0x8000
	defpage 7,0x4000, 0x8000

	incdir sprites/
	incdir music/
	incdir audio/
	incdir games/

static_cnt		equ		0xF000
	
	page 0
	code page 0

	org $4000

	DB "AB"      ; expansion ROM header
	DW start     ; start of the init code, 0 if no initcode
	DW 0         ; pointer to CALL statement handler, 0 if no such handler
	DW 0         ; pointer to expansion device handler, 0 if no such handler
	DW 0         ; pointer to the start of a tokenized basicprogram, 0 if no basicprogram
	DS 6,0       ; room reserved for future extensions

FONTS:
	; incbin "FONT.bin",0,128*8
	
title_chr:
	incbin	"chr.mgb",8+256*8,256*8
title_clr:
	incbin	"chr.mgb",7,256*8
title_map:
	incbin	"map.mgb",0,256*3
spgt:
	incbin	"coleco_sprites.bin"
	
	include "vsbios.asm"

start:
	ei
	ld sp, ($FC4A)              ; set the stack at HIMEM
	call codeinit

	ld hl,0xc000
	ld de,0xc000+1
	ld (hl),0
	ld bc,02200h
	ldir

	ld a,(#f3e0)
	or 2         ; Set 16x16 sprites
	ld (#f3e0),a

	call INIGRP
	ei
	halt	
	call	disscr
	ld a,0xF0
	ld (RG7SAV),a
	di
	out (#99),a
	ld a,128+7
	out (#99),a

	
	ld	de,0
	ld	bc,32*8*8
	ld	hl,title_chr
	call	ldirvm
	ld	de,256*8
	ld	bc,32*8*8
	ld	hl,title_chr
	call	ldirvm
	ld	de,256*8*2
	ld	bc,32*8*8
	ld	hl,title_chr
	call	ldirvm
	
	ld	de,0x2000
	ld	bc,32*8*8
	ld	hl,title_clr
	call	ldirvm
	ld	de,0x2000+256*8
	ld	bc,32*8*8
	ld	hl,title_clr
	call	ldirvm
	ld	de,0x2000+256*8*2
	ld	bc,32*8*8
	ld	hl,title_clr
	call	ldirvm
	
	ld	de,0x3800
	ld	hl,spgt
	ld	bc,64*32
	call	ldirvm

	ld	hl,title_map
	ld	de,0x1800
	ld	bc,256*3
	call	ldirvm
	

	ld	b,32
	ld	de,0x2000+256*8*2
1:	push	bc
	push	de
	ld	hl,back_color
	ld	bc,8
	call	ldirvm
	pop		de
	pop		bc
	ld	hl,8
	add	hl,de
	ex	de,hl
	djnz	1b

	halt
	
		ld de,0x1800+22*32
		call vpoke      
		xor	a
		out	(0x98),a
		ld de,0x1800+22*32+4
		call vpoke      
		ld	a,4
1:	
		out	(0x98),a
		inc	a
		cp	28
		jr	nz,1b
		ld de,0x1800+22*32+31
		call vpoke      
		ld	a,31
		out	(0x98),a

		ld de,0x1800+23*32+5
		call vpoke      
		ld	b,22
		ld	a,255
1:	
		out	(0x98),a
		djnz 1b
			
		ld de,256*8*2
		call vpoke        

		ld b,0
		xor	a
1:
		out	(0x98),a
		djnz	1b

	call printlist
	call print_cursor

	call	enascr
	
	xor a
	ld (currentsel),a
	
	xor	a
    ld	(CLIKSW),a
	
	ld	a,(static_cnt)
	and	3
	add	a,a
	ld	e,a
	ld	d,0
	ld	hl,musics
	add	hl,de
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a						; hl <- initial address of module - 100
	call	PT3_INIT			; Inits PT3 player

	ld	a,(static_cnt)
	inc	a
	and	3
	ld	(static_cnt),a

	ld	a,(0x002B)
	and 128
	ld 		(vsf),a                ; 0=>60Hz, !0=>50Hz
	ld      hl,cnt
	ld      (hl),1               ; reset the tic counter

	call ayFX_SETUP

	call	testesc
	jp	nz,hscroll_main
	
	ld	a,6
	ld (currentsel),a

	jp startgame
	
back_color:
	db 15h,17h,17h,17h,17h,17h,15h,14h
	
; main_loop:
	; ei
	; halt
	; call gest_keyb
	; call testspace
	; or a
	; jp z,startgame
	
	; jp main_loop
	
digital_signature:	db -1,1,-1

gest_keyb:
	ld a,(joy)              ; read joy/keyboard direction
	call rd_stk
	ld (joy_value),a	; save value
	cp 0
	jp z,resetpingpong
	cp 3
	jp z,next_page
	cp 7
	jp z,previous_page
	cp 5
	jp z,next_game
	cp 1
	jp z,previous_game
	ret
resetpingpong:
	xor a
	ld (pingpong),a
	ret
next_game:
	ld a,(pingpong)
	and	a	
	ret nz
	ld a,(currentsel)
	inc a
	cp nbgames
	ret nc
	call delete_cursor
	ld a,(currentsel)
	inc a
	cp nbgames
	ret nc
	ld (currentsel),a
	call print_cursor
	ld a,1
	ld (pingpong),a
	ret
previous_game:
	ld a,(pingpong)
	and	a	
	ret nz
	ld a,(currentsel)
	dec a
	cp 255
	ret z
	call delete_cursor
	ld a,(currentsel)
	dec a
	cp 255
	ret z
	ld (currentsel),a
	call print_cursor
	ld a,1
	ld (pingpong),a
	ret

delete_cursor:
	ld h,4
	ld a,(currentsel)
	add	a,9
	ld l,a
	ld bc,emptyselstr
	call printathl
	
	ld	a,7
	ld	c,1
	call ayFX_INIT
	ret
	
print_cursor:
	ld bc,currentselstr
	ld h,4
	ld a,(currentsel)
	add	a,9
	ld l,a
	call printathl
	ret

previous_page:
	ret
next_page:
	ret
startgame:
		call	psg_off
		call 	clrspr
		call	init32

	ld hl,switchbankandrun
	ld de,launch_program
	ld bc,switchend-switchbankandrun
	ldir
	jp launch_program

switchbankandrun:
	ld a,(currentsel)
	add a,a
	add a,a
	ld e,a
	ld d,0
	ld hl,gamelist+1
	add hl,de
	ld a,(hl)
	add	a,a
	add	a,a
	ld	(bb1),a
	inc	a
	ld	(bb2),a
	inc	a
	ld	(bb3),a
	inc	a
	ld	(bb4),a

	ld hl,(#4000+2)
	jp (hl)

switchend:

; printframe:
	; ld b,10
	; ld de,#0200


printlist:
	ld ix,gamelist
	ld b,nbgames
	ld hl,#0709
printlistloop:
	push hl
	push bc
	ld c,(ix+2)
	ld b,(ix+3)
	call printathl
	ld	bc,4
	add ix,bc
	pop bc
	pop hl
	inc hl
	djnz printlistloop
	ret

currentselstr: db 174-(116-'!'),175-(116-'!'),'!'
emptyselstr: db "  !"


gamelist:
	db #40,:game1
	dw game1str
	db #40,:game2
	dw game2str
	db #40,:game3
	dw game3str
	db #40,:game4
	dw game4str
	db #40,:game5
	dw game5str
	db #40,:game6
	dw game6str
	db #40,:game7
	dw game7str


game1str:  db "TUTANKHAM!"
game2str:  db "JUNGLE HUNT!"
game3str:  db "MIKIE!"
game4str:  db "MONTEZUMA'S REVENGE!"
game5str:  db "PEPPER II!"
game6str:  db "THE 3 DRAGON STORY!"
game7str:  db "TIME PILOT!"
	
	include AYFX-ROM.ASM
	include	PT3-ROM.ASM


musics:
	dw	music0
	dw	music1
	dw	music2
	dw	music3
music0: 
	incbin "COLECO Menu.pt3"
music1:
	incbin "a_little_journey.pt3"
music2:
	incbin "enchanted_woods.pt3"
music3:	
	incbin "Intro.pt3"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	include "hscroller.asm"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        page 1
        code page 1
game1:  incbin MUFTUT08.rom
        page 2
        code page 2
game2:	incbin muffhunt.rom
        page 3
        code page 3
game3:  incbin muffmik.rom
        page 4
        code page 4
game4:  incbin muffmont.rom
        page 5
        code page 5
game5:  incbin MFPEPPE2.ROM 
        page 6
        code page 6
game6:  incbin muffttds.rom
        page 7
        code page 7
game7:  incbin MFPILOTA.ROM




endrom: